#include "MojeOkno.h"
#include "Varia.h" //JednostkowyWektorNormalny3fv
#include "Modele.h" //Rysuj...
//#include "glext.h"
#include "resource.h"

#include "UkladyPunktowMaterialnych.h"
#include "UkladyPunktowMaterialnych2.h"

#include <typeinfo.h>

CMojeOknoGL::CMojeOknoGL()
:COknoGL(),zpm(NULL),przesunDoSrodkaMasy(false),
algorytm(algorytmVerleta),krokCzasowy(0.1),iloscKrokowWSerii(1),
//pauza(false),
typRzutowania(false)
{			
	//zpm=new ZderzajaceSiePunkty(20,Wektor(-2.5,-1.75,0),Wektor(2.5,1.75,0),0,1,1,3);
	//zpm=new ProblemBilardzisty(0.2,0.1);
	//zpm=new PunktyPoruszajaceSiePionowoIPoziomo(10,10,Wektor(-2.5,-1.75,0),Wektor(2.5,1.75,0),0,1,1,1);
	//zpm=new RuchyBrowna(30,3,Wektor(-2.5,-1.75,0),Wektor(2.5,1.75,0),0,1,1,3);
	zpm=new Poduszkowce(6,Wektor(-2.5,-1.75,0),Wektor(2.5,1.75,0),0,1,1,3);
	

	#ifdef _DEBUG
	if(zpm==NULL) MessageBox(uchwytOkna,"Brak zbioru punktw materialnych","Debug info",MB_OK);
	#endif
}

CMojeOknoGL::~CMojeOknoGL()
{
	delete zpm;
	zpm=NULL;
}

void CMojeOknoGL::RysujZPM(ZbiorPunktowMaterialnych* zpm,const double jednostkaDlugosci,bool koloruj) const
{
	if(zpm==NULL) return;

	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}

	GLUquadricObj* kwadryka=gluNewQuadric();
	gluQuadricDrawStyle(kwadryka,GLU_FILL); 
	glShadeModel(GL_SMOOTH);

	const int ilePunktowWKazdymWymiarze=10; //jakosc sfery (moze byc zalezna np. od tego, czy trwa przeciaganie)

	for(int indeks=0;indeks<zpm->LiczbaPunktow();++indeks)
	{		
		PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
        Wektor polozeniePunktu=jednostkaDlugosci*punkt->Polozenie();
  
        //tu jest dobre miejsce na ewentalne filtrowanie rysowanych punktow

        if(koloruj) glColor4fv(punkt->Kolor());

		glPushMatrix();	
		glTranslated(polozeniePunktu.X,polozeniePunktu.Y,polozeniePunktu.Z);
		gluSphere(kwadryka,jednostkaDlugosci*punkt->Promien(),ilePunktowWKazdymWymiarze,ilePunktowWKazdymWymiarze);
		glPopMatrix();						
    }

	gluDeleteQuadric(kwadryka);
	glPopMatrix();
}

void CMojeOknoGL::RysujWektor(Wektor punktPrzylozenia,Wektor wektor) const
{
	//glPushMatrix();

	//glBegin(GL_LINES);
	Wektor koniec=punktPrzylozenia+wektor;
	glVertex3d(punktPrzylozenia.X,punktPrzylozenia.Y,punktPrzylozenia.Z);
	glVertex3d(koniec.X,koniec.Y,koniec.Z);
	//glEnd();

	//glPopMatrix();
}

void CMojeOknoGL::RysujZPMPredkosci(ZbiorPunktowMaterialnych* zpm,const double jednostkaDlugosci,const float gruboscLinii,bool koloruj) const
{
	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}
	
	glLineWidth(gruboscLinii);
	glBegin(GL_LINES);
	for(int indeks=0;indeks<zpm->LiczbaPunktow();indeks++)
	{		
		PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
		if(koloruj) glColor4fv(punkt->Kolor());
		RysujWektor(jednostkaDlugosci*punkt->Polozenie(),jednostkaDlugosci*punkt->Predkosc());
	}
	glEnd();

	glPopMatrix();
}

void CMojeOknoGL::RysujZPMLinie(ZbiorPunktowMaterialnych* zpm,const double jednostkaDlugosci,const float gruboscLinii,bool koloruj,bool cien,float poziomPodloza) const
{
	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}

	if(cien)
	{
		//rysowanie cienia
		glLineWidth(gruboscLinii);
		glColor3f(0,0,0);
		glBegin(GL_LINE_STRIP);
		for(int indeks=0;indeks<zpm->LiczbaPunktow();indeks++)
		{
			PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
			Wektor polozeniePunktu=jednostkaDlugosci*punkt->Polozenie();		
			glVertex3d(polozeniePunktu.X,poziomPodloza,polozeniePunktu.Z);
		}
		glEnd();
	}

	//rysowanie linii
	glLineWidth(gruboscLinii);
	glBegin(GL_LINE_STRIP);
	for(int indeks=0;indeks<zpm->LiczbaPunktow();indeks++)
	{		
		PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
		Wektor polozeniePunktu=jednostkaDlugosci*punkt->Polozenie();		
		if(koloruj) glColor4fv(punkt->Kolor());
		glVertex3d(polozeniePunktu.X,polozeniePunktu.Y,polozeniePunktu.Z);
	}
	glEnd();

	glPopMatrix();
}

void CMojeOknoGL::RysujZPMSiatke(Siatka* zpm,const double jednostkaDlugosci,const float gruboscLinii,bool koloruj) const
{
	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}

	//rysowanie siatki
	glLineWidth(gruboscLinii);	
	int Nx=zpm->PobierzNx();
	int Ny=zpm->PobierzNy();
	//w kierunku x
	for(int iy=0;iy<Ny;++iy)
	{
		glBegin(GL_LINE_STRIP);		
		for(int ix=0;ix<Nx;++ix)
		{
			int indeks=ix+Nx*iy;
			PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
			Wektor polozeniePunktu=jednostkaDlugosci*punkt->Polozenie();		
			if(koloruj) glColor4fv(punkt->Kolor());
			glVertex3d(polozeniePunktu.X,polozeniePunktu.Y,polozeniePunktu.Z);
		}
		glEnd();
	}
	//w kierunku y
	for(int ix=0;ix<Nx;++ix)
	{
		glBegin(GL_LINE_STRIP);
		for(int iy=0;iy<Ny;++iy)
		{
			int indeks=ix+Nx*iy;
			PunktMaterialny* punkt=zpm->PobierzPunktMaterialny(indeks);
			Wektor polozeniePunktu=jednostkaDlugosci*punkt->Polozenie();		
			if(koloruj) glColor4fv(punkt->Kolor());
			glVertex3d(polozeniePunktu.X,polozeniePunktu.Y,polozeniePunktu.Z);
		}
		glEnd();
	}

	glPopMatrix();
}

void RysujCzworokat(PunktMaterialny* punkt00,PunktMaterialny* punkt10,PunktMaterialny* punkt11,PunktMaterialny* punkt01,const double jednostkaDlugosci,bool koloruj)
{
	Wektor polozeniePunktu00=jednostkaDlugosci*punkt00->Polozenie();
	Wektor polozeniePunktu10=jednostkaDlugosci*punkt10->Polozenie();		
	Wektor polozeniePunktu11=jednostkaDlugosci*punkt11->Polozenie();		
	Wektor polozeniePunktu01=jednostkaDlugosci*punkt01->Polozenie();		

	//pierwszy trojkat
	//normalna			
	Wektor wektorNormalny=IloczynWektorowy(polozeniePunktu10-polozeniePunktu00,polozeniePunktu01-polozeniePunktu00);
	double wektorNormalnyTablica[3];
	glNormal3dv(wektorNormalny.ZapiszWTablicy(wektorNormalnyTablica));
	//00			
	if(koloruj) glColor4fv(punkt00->Kolor());
	glVertex3d(polozeniePunktu00.X,polozeniePunktu00.Y,polozeniePunktu00.Z);
	//10			
	if(koloruj) glColor4fv(punkt10->Kolor());
	glVertex3d(polozeniePunktu10.X,polozeniePunktu10.Y,polozeniePunktu10.Z);
	//01
	if(koloruj) glColor4fv(punkt01->Kolor());
	glVertex3d(polozeniePunktu01.X,polozeniePunktu01.Y,polozeniePunktu01.Z);									
			
	//drugi trojkat
	//01
	if(koloruj) glColor4fv(punkt01->Kolor());
	glVertex3d(polozeniePunktu01.X,polozeniePunktu01.Y,polozeniePunktu01.Z);									
	//10			
	if(koloruj) glColor4fv(punkt10->Kolor());
	glVertex3d(polozeniePunktu10.X,polozeniePunktu10.Y,polozeniePunktu10.Z);
	//11
	if(koloruj) glColor4fv(punkt11->Kolor());
	glVertex3d(polozeniePunktu11.X,polozeniePunktu11.Y,polozeniePunktu11.Z);			
	//normalna			
	wektorNormalny=IloczynWektorowy(polozeniePunktu01-polozeniePunktu11,polozeniePunktu10-polozeniePunktu11);			
	glNormal3dv(wektorNormalny.ZapiszWTablicy(wektorNormalnyTablica));
}

void CMojeOknoGL::RysujZPMPlaszczyzne(Siatka* zpm,const double jednostkaDlugosci,bool koloruj) const
{
	glDisable(GL_CULL_FACE);	

	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}

	//rysowanie plaszczyzny
	int Nx=zpm->PobierzNx();
	int Ny=zpm->PobierzNy();
	glBegin(GL_TRIANGLES);
	for(int iy=0;iy<Ny-1;iy+=1)
	{		
		for(int ix=0;ix<Nx-1;ix+=1)
		{
			int indeks=ix+Nx*iy; PunktMaterialny* punkt00=zpm->PobierzPunktMaterialny(indeks);
			indeks=ix+1+Nx*iy; PunktMaterialny* punkt10=zpm->PobierzPunktMaterialny(indeks);
			indeks=ix+1+Nx*(iy+1); PunktMaterialny* punkt11=zpm->PobierzPunktMaterialny(indeks);
			indeks=ix+Nx*(iy+1); PunktMaterialny* punkt01=zpm->PobierzPunktMaterialny(indeks);

			RysujCzworokat(punkt00,punkt10,punkt11,punkt01,jednostkaDlugosci,koloruj);
		}		
	}
	glEnd();

	glPopMatrix();
}


void CMojeOknoGL::RysujZPMSzescian(Szescian* zpm,const double jednostkaDlugosci,bool koloruj) const
{
	glEnable(GL_CULL_FACE);
	glCullFace(GL_BACK);

	//glShadeModel(GL_FLAT);

	glPushMatrix();

	//zero ukladu wspolrzednych w srodku masy	
	if (przesunDoSrodkaMasy)
	{
		Wektor srodekMasy=jednostkaDlugosci*zpm->SrodekMasy();
		glTranslated(-srodekMasy.X,-srodekMasy.Y,-srodekMasy.Z);
	}

	//rysowanie plaszczyzny
	int Nx=zpm->PobierzNx();
	int Ny=zpm->PobierzNy();
	int Nz=zpm->PobierzNy();
	glBegin(GL_TRIANGLES);	

	//sciany przednia i tylna (OXY)
	for(int iz=0;iz<=Nz-1;iz+=Nz-1)
		for(int iy=0;iy<Ny-1;iy+=1)
			for(int ix=0;ix<Nx-1;ix+=1)
			{			
				PunktMaterialny* punkt00=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy,iz));
				PunktMaterialny* punkt10=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix+1,iy,iz));
				PunktMaterialny* punkt11=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix+1,iy+1,iz));
				PunktMaterialny* punkt01=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy+1,iz));
				if (iz==Nz-1)
				{
					PunktMaterialny* tmp=punkt10;
					punkt10=punkt01;
					punkt01=tmp;
				}
				RysujCzworokat(punkt00,punkt01,punkt11,punkt10,jednostkaDlugosci,koloruj);				
			}

	//sciany lewa i prawa (OYZ)
	for(int ix=0;ix<=Nx-1;ix+=Nx-1)
		for(int iy=0;iy<Ny-1;iy+=1)
			for(int iz=0;iz<Nz-1;iz+=1)
			{			
				PunktMaterialny* punkt00=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy,iz));
				PunktMaterialny* punkt10=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy+1,iz));
				PunktMaterialny* punkt11=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy+1,iz+1));
				PunktMaterialny* punkt01=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy,iz+1));		
				if (ix==Nx-1)
				{
					PunktMaterialny* tmp=punkt10;
					punkt10=punkt01;
					punkt01=tmp;
				}
				RysujCzworokat(punkt00,punkt01,punkt11,punkt10,jednostkaDlugosci,koloruj);
			}

	//sciany gorna i dolna (OXZ)
	for(int iy=0;iy<=Ny-1;iy+=Ny-1)
		for(int iz=0;iz<Nz-1;iz+=1)
			for(int ix=0;ix<Nx-1;ix+=1)
			{			
				PunktMaterialny* punkt00=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy,iz));
				PunktMaterialny* punkt10=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix,iy,iz+1));
				PunktMaterialny* punkt11=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix+1,iy,iz+1));
				PunktMaterialny* punkt01=zpm->PobierzPunktMaterialny(zpm->PobierzIndeksPunktu(ix+1,iy,iz));
				if (iy==Ny-1)
				{
					PunktMaterialny* tmp=punkt10;
					punkt10=punkt01;
					punkt01=tmp;
				}
				RysujCzworokat(punkt00,punkt01,punkt11,punkt10,jednostkaDlugosci,koloruj);
			}


	glEnd();

	glPopMatrix();
}


LRESULT CMojeOknoGL::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{	
	const int IDT_TIMER_OBLICZEN=3;
	const int IDT_TIMER_RYSOWANIA=4;

	long wynik=COknoGL::WndProc(hWnd,message,wParam,lParam);		

	switch (message)
	{
		case WM_CREATE: //pole uchwyt okna nie jest zainicjowane w WM_CREATE -> uzywac hWnd
			if (SetTimer(hWnd,IDT_TIMER_OBLICZEN,USER_TIMER_MINIMUM,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera obliczen","",MB_OK | MB_ICONERROR);
			if (SetTimer(hWnd,IDT_TIMER_RYSOWANIA,50,NULL)==0)
				MessageBox(hWnd,"Nie udao si ustawi timera rysowania","",MB_OK | MB_ICONERROR);
			poprzedniCzas=GetTickCount();
			break;
		case WM_TIMER:
			if (pauza) break;
			switch(wParam)
			{
				case IDT_TIMER_OBLICZEN:
					if (zpm!=NULL)
						for(int i=0;i<iloscKrokowWSerii;i++) 
							zpm->KrokNaprzod(krokCzasowy,algorytm);					
					break;
				case IDT_TIMER_RYSOWANIA:
					RysujScene();
					break;
			}
			wynik=0;

			break;
		case WM_DESTROY:
			KillTimer(uchwytOkna,IDT_TIMER_OBLICZEN);
			KillTimer(uchwytOkna,IDT_TIMER_RYSOWANIA);
			break;

		case WM_KEYUP:
			{
				Wektor przyspieszenieSterowanegoPoduszkowca=((Poduszkowce*)zpm)->PobierzPrzyspieszeniePoduszkowca();
				switch(wParam)
				{
					case 'L':
					case 'J':
						przyspieszenieSterowanegoPoduszkowca.X=0;
						break;
					case 'I':
					case 'K':
						przyspieszenieSterowanegoPoduszkowca.Y=0;
						break;
				}
				((Poduszkowce*)zpm)->UstawPrzyspieszeniePoduszkowca(przyspieszenieSterowanegoPoduszkowca);
			}
			break;
		case WM_KEYDOWN:
			Wektor przyspieszenieSterowanegoPoduszkowca=((Poduszkowce*)zpm)->PobierzPrzyspieszeniePoduszkowca();
			const double zmianaPrzyspieszenia=0.1;
			bool wywolacRysujScene=true;
			switch(wParam)
			{
				case 'C':
					typRzutowania=!typRzutowania;
					UstawienieSceny(typRzutowania);
					break;
				case VK_SPACE:
					pauza=!pauza;
					wywolacRysujScene=false;
					break;

				case 'L':
					przyspieszenieSterowanegoPoduszkowca.X+=zmianaPrzyspieszenia;
					break;
				case 'J':
					przyspieszenieSterowanegoPoduszkowca.X-=zmianaPrzyspieszenia;
					break;
				case 'I':
					przyspieszenieSterowanegoPoduszkowca.Y+=zmianaPrzyspieszenia;
					break;
				case 'K':
					przyspieszenieSterowanegoPoduszkowca.Y-=zmianaPrzyspieszenia;
					break;
			}
			if(przyspieszenieSterowanegoPoduszkowca.X>zmianaPrzyspieszenia) przyspieszenieSterowanegoPoduszkowca.X=zmianaPrzyspieszenia;
			if(przyspieszenieSterowanegoPoduszkowca.X<-zmianaPrzyspieszenia) przyspieszenieSterowanegoPoduszkowca.X=-zmianaPrzyspieszenia;
			if(przyspieszenieSterowanegoPoduszkowca.Y>zmianaPrzyspieszenia) przyspieszenieSterowanegoPoduszkowca.Y=zmianaPrzyspieszenia;
			if(przyspieszenieSterowanegoPoduszkowca.Y<-zmianaPrzyspieszenia) przyspieszenieSterowanegoPoduszkowca.Y=-zmianaPrzyspieszenia;
			((Poduszkowce*)zpm)->UstawPrzyspieszeniePoduszkowca(przyspieszenieSterowanegoPoduszkowca);
			if (pauza && wywolacRysujScene) RysujScene();
			break;
	}
	
	return wynik;
}

void CMojeOknoGL::RysujAktorow()
{	
	const double jednostkaDlugosci=1;

	//srodek ukladu wspolrzednych
	glColor3f(1,1,1);
	glPointSize(1);
	glBegin(GL_POINTS);
	glVertex3f(0,0,0);
	glEnd();	

	RysujZPM(zpm,jednostkaDlugosci,true); //rozmiar 0.1 lub 0.05
	//RysujZPMLinie(zpm,jednostkaDlugosci,1,true,false,0);
	RysujZPMPredkosci(zpm,jednostkaDlugosci,1,true);

	//przyspieszenie
	PunktMaterialny* sterowanyPunkt=zpm->PobierzPunktMaterialny(0);
	Poduszkowce* poduszkowce=(Poduszkowce*)zpm;
	glColor3f(1,0,0);
	glLineWidth(2);
	glBegin(GL_LINES);
	RysujWektor(jednostkaDlugosci*sterowanyPunkt->Polozenie(),jednostkaDlugosci*poduszkowce->PobierzPrzyspieszeniePoduszkowca());	
	glEnd();
	
	//pudlo
	ObszarZabroniony* oz=NULL;
	oz=((ZbiorPunktowMaterialnychZObszaremZabronionym*)zpm)->PobierzObszarZabroniony();
	if(oz!=NULL && typeid(*oz)==typeid(Pudlo))	
	{
		Pudlo* pudlo=(Pudlo*)oz;
		glColor4f(0.5f,0.5f,1,0.15f);
		glPushMatrix();
		Wektor polozenieOsi=jednostkaDlugosci*pudlo->PobierzSrodek();
		Wektor rozmiar=jednostkaDlugosci*pudlo->PobierzRozmiar();	
		glTranslated(polozenieOsi.X,polozenieOsi.Y,polozenieOsi.Z);
		//Modele::RysujProstopadloscian_SortowanieScian((float)rozmiar.X,(float)rozmiar.Y,(float)rozmiar.Z,false,0.15f);
		Modele::RysujProstopadloscian((float)rozmiar.X,(float)rozmiar.Y,(float)rozmiar.Z,false,false,NULL);
		glPopMatrix();
	}
}

#pragma region Zrodla swiatla
//zrodla swiatla
void CMojeOknoGL::ZrodlaSwiatla()
{
	natezenie_swiatla_tla=0.5f;
	MlecznaZarowka(0.5f);
	
	/*
	//mgla
	glEnable(GL_FOG);
	const float biel[4]={1.0,1.0,1.0,1.0};
	glFogfv(GL_FOG_COLOR,biel);
	glFogf(GL_FOG_START,0.0);
	glFogf(GL_FOG_END,100.0);
	glFogf(GL_FOG_MODE,GL_LINEAR);
	*/	
}


void CMojeOknoGL::MlecznaZarowka(float jasnosc)
{	
	const float kolor[4]={jasnosc,jasnosc,jasnosc,1.0f};
	const float pozycja[4]={5.0f,0.0f,5.0f,1.0f};	
	glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor);
	glEnable(GL_LIGHT1);
}

void CMojeOknoGL::ZoltaIZielonaMleczneZarowki()
{
	//zolta mleczna zarowka
	const float kolor_zolta[4]={1.0f,1.0f,0.0f,1.0f};
	const float pozycja_zolta[4]={-2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT2,GL_POSITION,pozycja_zolta);
	glLightfv(GL_LIGHT2,GL_DIFFUSE,kolor_zolta);
	//glEnable(GL_LIGHT2);

	//zielona mleczna zarowka
	const float kolor_zielony[4]={0.0f,1.0f,0.0f,1.0f};
	const float pozycja_zielony[4]={2.0f,0.0f,1.0f,1.0f};
	glLightfv(GL_LIGHT3,GL_POSITION,pozycja_zielony);
	glLightfv(GL_LIGHT3,GL_DIFFUSE,kolor_zielony);
	//glEnable(GL_LIGHT3);
}

void CMojeOknoGL::Reflektor(float jasnoscRozblysk,float jasnoscRozproszone)
{
	const float kolor_rozproszone[4]={jasnoscRozproszone,jasnoscRozproszone,jasnoscRozproszone,1.0f};
	const float kolor_rozblysk[4]={jasnoscRozblysk,jasnoscRozblysk,jasnoscRozblysk,1.0};
	const float pozycja[4]={-10.0f,-10.0f,10.0f,1.0f};	
	const float kierunek[4]={1.0,1.0,-1.0,1.0};   
	const float szerokosc_wiazki=30.0f; //w stopniach
	const float wygaszanie=1.0f;
   
	glLightfv(GL_LIGHT4,GL_POSITION,pozycja);
	glLightfv(GL_LIGHT4,GL_DIFFUSE,kolor_rozproszone);

	glLightfv(GL_LIGHT4,GL_SPECULAR,kolor_rozblysk);
	glLightfv(GL_LIGHT4,GL_SPOT_DIRECTION,kierunek);
	glLightf(GL_LIGHT4,GL_SPOT_CUTOFF,szerokosc_wiazki);
	glLightf(GL_LIGHT4,GL_SPOT_EXPONENT,wygaszanie);
	//glEnable(GL_LIGHT4);
}
#pragma endregion

#pragma region PDB2ZPM //jako zadanie!!!!!
/*
bool CMojeOknoGL::OpenPDBFile(const char* nazwaPliku)
{
	//plik podawany z parametru linii
    try
	{
		pdb=new PDB(nazwaPliku);        
	}
	catch(const std::exception& exc)
    {
		char komunikat[256]="Wystpi bd przy prbie zaadowania obiektu PDB:\n";
		strcat(komunikat,exc.what());
		MessageBox(uchwytOkna,komunikat,"Przegladarka PDB",MB_OK | MB_ICONERROR);
		return false;
    }

	return true;
}

void CMojeOknoGL::WybierzKolorAtomu(const char* symbolPierwiastka,const float alpha=1.0f) const
{
   switch(symbolPierwiastka[0]) //na razie tylko jednoliterowe
   {
      case 'C': glColor4f(0.25f,0.75f,0.75f,alpha); break;
      case 'O': glColor4f(1.00f,0.00f,0.00f,alpha); break;
      case 'H': glColor4f(1.00f,1.00f,1.00f,alpha); break;
      case 'N': glColor4f(0.00f,0.00f,1.00f,alpha); break;
      case 'P': glColor4f(0.50f,0.50f,0.20f,alpha); break;
      default: glColor4f(0.50f,0.50f,0.50f,alpha); break;
   }
}

ZbiorPunktowMaterialnych* PDB2ZPM(PDB* pdb,ZbiorPunktowMaterialnych* zpm)
{
}
*/
#pragma endregion
